// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntitySwitch.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntitySwitch.h"
#include "Level.h"
#include "Application.h"




EntitySwitch::EntitySwitch()
{

  SetFrame( Dobbs::ANIM_SWITCH_ON );
  SetRect( &m_CollisionRect, 0, 0, 64, 32 );
  m_Floating = true;
  m_CanCollideWithBackground = false;

  m_SwitchOffTime = 0.0f;

}



EntitySwitch::~EntitySwitch() 
{
}



void EntitySwitch::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
    case EE_BLOCKED_RIGHT:
    case EE_BLOCKED_TOP:
    case EE_BLOCKED_BOTTOM:
      Die();
      break;
    case EE_DIE:
      m_pLevel->SpawnEntity( Dobbs::ENTITY_TYPE_EXPLOSION, 0, GetX(), GetY() );
      g_App.PlaySound( "Player.Explode" );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntitySwitch::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  if ( m_SwitchOffTime > 0.0f )
  {
    m_SwitchOffTime -= ElapsedTime;
    if ( m_SwitchOffTime <= 0.0f )
    {
      m_SwitchOffTime = 0.0f;
      SetFrame( Dobbs::ANIM_SWITCH_ON );
      g_App.PlaySound( "Switch" );
    }
  }

  Entity::UpdateTimed( aLevel, ElapsedTime );

}



bool EntitySwitch::Switch()
{

  if ( m_SwitchOffTime == 0.0f )
  {
    m_SwitchOffTime = 0.25f;
    SetFrame( Dobbs::ANIM_SWITCH_OFF );
    g_App.PlaySound( "Switch" );
    return true;
  }
  return false;

}